#version 460

uniform samplerCube tex_cm;

in vec3 n;
in vec3 incident;
in vec3 pos;

out vec4 color;

void main() {

    vec3 nn = normalize(n);
    vec3 i = normalize(incident);

    vec3 refl = reflect(i, nn);

    // box max abs coord
    float d = 10;

 	vec3 i1 = (d - pos) / refl;
	vec3 i2 = (-d - pos) / refl;

    // max between pos and neg sides
	vec3 furtherst = max(i1,i2);
    // select closest side
	float k = min(min(furtherst.x, furtherst.y), furtherst.z);

	vec3 dir = pos + k * refl;
   

    color = texture(tex_cm, dir);

}
